/*
 * Decompiled with CFR 0.152.
 */
package net.hat.gt.entities;

import com.google.common.collect.ImmutableList;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.hat.gt.entities.AbstractGoblinEntity;
import net.minecraft.class_1268;
import net.minecraft.class_1306;
import net.minecraft.class_3532;
import net.minecraft.class_3881;
import net.minecraft.class_3882;
import net.minecraft.class_4587;
import net.minecraft.class_4595;
import net.minecraft.class_5603;
import net.minecraft.class_5605;
import net.minecraft.class_5606;
import net.minecraft.class_5607;
import net.minecraft.class_5609;
import net.minecraft.class_5610;
import net.minecraft.class_630;

@Environment(value=EnvType.CLIENT)
public class GoblinTraderModel<G extends AbstractGoblinEntity>
extends class_4595<AbstractGoblinEntity>
implements class_3881,
class_3882 {
    private final class_630 root;
    private final class_630 head;
    public final class_630 hood;
    private final class_630 body;
    private final class_630 leftEar;
    private final class_630 rightEar;
    private final class_630 rightArm;
    private final class_630 leftArm;
    private final class_630 leftLeg;
    private final class_630 rightLeg;
    private final class_630 bag;
    private AbstractGoblinEntity entity;

    public GoblinTraderModel(class_630 root) {
        this.root = root;
        this.head = root.method_32086("head");
        this.hood = root.method_32086("hood");
        class_630 nose = this.head.method_32086("nose");
        this.rightEar = this.head.method_32086("rightEar");
        this.leftEar = this.head.method_32086("leftEar");
        this.body = root.method_32086("body");
        this.bag = this.body.method_32086("bag");
        this.rightArm = root.method_32086("right_arm");
        this.leftArm = root.method_32086("left_arm");
        this.leftLeg = root.method_32086("left_leg");
        this.rightLeg = root.method_32086("right_leg");
    }

    public static class_5607 getTexturedModelData() {
        class_5609 modelData = new class_5609();
        class_5610 root = modelData.method_32111();
        class_5610 body = root.method_32117("body", class_5606.method_32108().method_32101(12, 12).method_32097(-2.0f, 0.0f, -2.0f, 4.0f, 4.0f, 4.0f), class_5603.method_32090((float)0.0f, (float)16.0f, (float)0.0f));
        body.method_32117("bag", class_5606.method_32108().method_32101(0, 20).method_32097(-2.5f, -2.0f, 2.0f, 5.0f, 7.0f, 3.0f), class_5603.field_27701);
        class_5610 head = root.method_32117("head", class_5606.method_32108().method_32101(0, 0).method_32097(-4.0f, -6.0f, -3.0f, 8.0f, 6.0f, 6.0f), class_5603.method_32090((float)0.0f, (float)16.0f, (float)0.0f));
        head.method_32117("leftEar", class_5606.method_32108().method_32101(0, 8).method_32097(0.0f, -2.0f, 0.0f, 0.0f, 4.0f, 4.0f), class_5603.method_32090((float)4.0f, (float)-3.0f, (float)1.0f));
        head.method_32117("rightEar", class_5606.method_32108().method_32101(8, 8).method_32097(0.0f, -2.0f, 0.0f, 0.0f, 4.0f, 4.0f), class_5603.method_32090((float)-4.0f, (float)-3.0f, (float)1.0f));
        head.method_32117("nose", class_5606.method_32108().method_32101(22, 0).method_32097(-1.0f, 0.0f, -2.0f, 2.0f, 4.0f, 2.0f), class_5603.method_32090((float)0.0f, (float)-3.0f, (float)-3.0f));
        root.method_32117("right_arm", class_5606.method_32108().method_32101(30, 0).method_32097(-1.0f, -1.0f, -1.0f, 2.0f, 5.0f, 2.0f), class_5603.method_32090((float)-3.0f, (float)17.0f, (float)0.0f));
        root.method_32117("left_arm", class_5606.method_32108().method_32101(38, 0).method_32097(-1.0f, -1.0f, -1.0f, 2.0f, 5.0f, 2.0f), class_5603.method_32090((float)3.0f, (float)17.0f, (float)0.0f));
        root.method_32117("left_leg", class_5606.method_32108().method_32101(36, 9).method_32097(-1.0f, 0.0f, -1.5f, 2.0f, 4.0f, 3.0f), class_5603.method_32090((float)1.0f, (float)20.0f, (float)0.0f));
        root.method_32117("right_leg", class_5606.method_32108().method_32101(26, 9).method_32097(-1.0f, 0.0f, -1.5f, 2.0f, 4.0f, 3.0f), class_5603.method_32090((float)-1.0f, (float)20.0f, (float)0.0f));
        root.method_32117("hood", class_5606.method_32108().method_32101(0, 32).method_32098(-4.0f, -6.0f, -3.0f, 8.0f, 8.0f, 6.0f, new class_5605(0.5f)), class_5603.method_32090((float)0.0f, (float)16.0f, (float)0.0f));
        return class_5607.method_32110((class_5609)modelData, (int)46, (int)46);
    }

    public Iterable<class_630> method_22960() {
        return ImmutableList.of((Object)this.root);
    }

    public void setAngles(AbstractGoblinEntity entity, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headroll) {
        this.entity = entity;
        this.leftEar.field_3675 = 0.7854f;
        this.rightEar.field_3675 = -0.7854f;
        float rotateFactor = (float)entity.method_18798().method_1027();
        rotateFactor /= 0.2f;
        if ((rotateFactor = rotateFactor * rotateFactor * rotateFactor) < 1.0f) {
            rotateFactor = 1.0f;
        }
        this.rightArm.field_3654 = class_3532.method_15362((float)(limbAngle * 0.6662f + (float)Math.PI)) * 2.0f * limbDistance * 0.5f / rotateFactor;
        this.leftArm.field_3654 = class_3532.method_15362((float)(limbAngle * 0.6662f)) * 2.0f * limbDistance * 0.5f / rotateFactor;
        this.rightArm.field_3675 = 0.0f;
        this.rightArm.field_3674 = 0.0f;
        this.leftArm.field_3675 = 0.0f;
        this.leftArm.field_3674 = 0.0f;
        this.rightLeg.field_3654 = class_3532.method_15362((float)(limbAngle * 0.6662f)) * 1.4f * limbDistance / rotateFactor;
        this.leftLeg.field_3654 = class_3532.method_15362((float)(limbAngle * 0.6662f + (float)Math.PI)) * 1.4f * limbDistance / rotateFactor;
        this.head.field_3675 = headYaw * ((float)Math.PI / 180);
        this.head.field_3654 = headroll * ((float)Math.PI / 180);
        this.hood.method_17138(this.head);
        this.bag.field_3654 = (float)Math.toRadians(0.0);
        this.bag.field_3656 = 0.0f;
        this.bag.field_3655 = 0.0f;
        this.bag.field_3665 = entity.hasBag();
        this.leftArm.field_3655 = 0.0f;
        this.leftArm.field_3656 = 17.0f;
        this.rightArm.field_3655 = 0.0f;
        this.rightArm.field_3656 = 17.0f;
        if (this.field_3447 > 0.0f) {
            class_630 arm = this.rightArm;
            float progress = this.field_3447;
            this.body.field_3675 = class_3532.method_15374((float)(class_3532.method_15355((float)progress) * ((float)Math.PI * 2))) * 0.2f;
            this.rightArm.field_3675 += this.body.field_3675;
            this.leftArm.field_3675 += this.body.field_3675;
            this.leftArm.field_3654 += this.body.field_3675;
            progress = 1.0f - this.field_3447;
            progress *= progress;
            progress *= progress;
            progress = 1.0f - progress;
            float f2 = class_3532.method_15374((float)(progress * (float)Math.PI));
            float f3 = class_3532.method_15374((float)(this.field_3447 * (float)Math.PI)) * -(this.head.field_3654 - 0.7f) * 0.75f;
            arm.field_3654 = (float)((double)arm.field_3654 - ((double)f2 * 1.2 + (double)f3));
            arm.field_3675 += this.body.field_3675 * 2.0f;
            arm.field_3674 += class_3532.method_15374((float)(this.field_3447 * (float)Math.PI)) * -0.4f;
        }
        if (entity.method_6115()) {
            double rotateX = Math.toRadians(-90.0 + 5.0 * Math.sin(animationProgress));
            this.leftArm.field_3654 = (float)rotateX;
            this.rightArm.field_3654 = (float)rotateX;
            this.rightLeg.field_3675 = (float)Math.toRadians(25.0);
            this.leftLeg.field_3654 = (float)Math.toRadians(-90.0);
            this.leftLeg.field_3675 = (float)Math.toRadians(-25.0);
            this.rightLeg.field_3654 = (float)Math.toRadians(-90.0);
        } else {
            if (entity.isHoldingItem(class_1268.field_5808)) {
                if (entity.method_6068().equals((Object)class_1306.field_6183)) {
                    this.rightArm.field_3654 = (float)Math.toRadians(-50.0);
                } else {
                    this.leftArm.field_3654 = (float)Math.toRadians(-50.0);
                }
            }
            if (entity.isHoldingItem(class_1268.field_5810)) {
                if (entity.method_6068().equals((Object)class_1306.field_6182)) {
                    this.rightArm.field_3654 = (float)Math.toRadians(-50.0);
                } else {
                    this.leftArm.field_3654 = (float)Math.toRadians(-50.0);
                }
            }
            this.rightLeg.field_3675 = (float)Math.toRadians(0.0);
            this.leftLeg.field_3675 = (float)Math.toRadians(0.0);
        }
        boolean isRaft = false;
        if (entity.isRaining() && !entity.isStunned() && !entity.method_6115() && entity.hasBag() && !isRaft) {
            this.rightArm.field_3654 = (float)Math.toRadians(-140.0);
            this.rightArm.field_3675 = (float)Math.toRadians(-20.0);
            this.leftArm.field_3654 = (float)Math.toRadians(-140.0);
            this.leftArm.field_3675 = (float)Math.toRadians(20.0);
            this.bag.field_3654 = (float)Math.toRadians(130.0);
            this.bag.field_3656 = -3.0f;
            this.bag.field_3655 = -3.0f;
            this.leftArm.field_3655 = -3.0f;
            this.leftArm.field_3656 = 15.0f;
            this.rightArm.field_3655 = -3.0f;
            this.rightArm.field_3656 = 15.0f;
        }
        if (isRaft) {
            this.rightLeg.field_3675 = (float)Math.toRadians(25.0);
            this.leftLeg.field_3654 = (float)Math.toRadians(-90.0);
            this.leftLeg.field_3675 = (float)Math.toRadians(-25.0);
            this.rightLeg.field_3654 = (float)Math.toRadians(-90.0);
            this.bag.field_3654 = (float)Math.toRadians(-90.0);
            this.bag.field_3656 = 6.0f;
            this.bag.field_3655 = 3.0f;
        }
    }

    public void method_2803(class_1306 arm, class_4587 matrices) {
        if (this.entity != null && !this.entity.method_6115()) {
            switch (arm) {
                case field_6182: {
                    this.leftArm.method_22703(matrices);
                    matrices.method_22904(-0.05, -0.15, 0.25);
                    break;
                }
                case field_6183: {
                    this.rightArm.method_22703(matrices);
                    matrices.method_22904(0.05, -0.15, 0.25);
                }
            }
            matrices.method_22905(0.75f, 0.75f, 0.75f);
            return;
        }
        switch (arm) {
            case field_6182: {
                this.leftArm.method_22703(matrices);
                if (this.entity.isHoldingItem(class_1268.field_5808) && this.entity.isHoldingItem(class_1268.field_5810)) {
                    matrices.method_22904(-0.05, -0.15, 0.25);
                } else {
                    matrices.method_22904(-0.235, -0.15, 0.25);
                }
                matrices.method_22905(0.75f, 0.75f, 0.75f);
                break;
            }
            case field_6183: {
                this.rightArm.method_22703(matrices);
                if (this.entity.isHoldingItem(class_1268.field_5808) && this.entity.isHoldingItem(class_1268.field_5810)) {
                    matrices.method_22904(0.05, -0.15, 0.25);
                } else {
                    matrices.method_22904(0.235, -0.15, 0.25);
                }
                matrices.method_22905(0.75f, 0.75f, 0.75f);
            }
        }
    }

    public class_630 method_2838() {
        return this.head;
    }
}

